options(width = 120)
#*********************************************************************************#
#*                                                                                #
#* Purpose: R program to create permanent R .RDS data set                         #
#*          harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta          #
#*          with the Harmonized TUS CPS 1992 through 1993 replicate weights 92-33 #
#*                                                                                #
#*   Notes: The program uses the package readr                                    #
#                                                                                 #
#*********************************************************************************#

##############################################################################################################
# Set working directories
##############################################################################################################

setwd("//westat.com/DFS/NCIDCCPS/DCCPS - Global/Scientific Projects/TUS-CPS/Statistician/ifc/R work/prg/3. Harmonized data")
getwd()

##############################################################################################################
# Load libraries
#
library(readr)


##############################################################################################################
## Create data dictionary with varaible names, witdths, type and labels
##############################################################################################################

data_diccionary <-
'SurYear         1       4           numeric        "Survey year" 
SurMonth        5       6           numeric        "Survey month" 
RecordID        7       28          character      "Record ID (Unique within survey month)" 
SmplWgt         29      39          numeric        "Self Response Sample Weight" 
RepWt001        40      50          numeric        "Replicate Weight #1" 
RepWt002        51      61          numeric        "Replicate Weight #2" 
RepWt003        62      72          numeric        "Replicate Weight #3" 
RepWt004        73      83          numeric        "Replicate Weight #4" 
RepWt005        84      94          numeric        "Replicate Weight #5" 
RepWt006        95      105         numeric        "Replicate Weight #6" 
RepWt007        106     116         numeric        "Replicate Weight #7" 
RepWt008        117     127         numeric        "Replicate Weight #8" 
RepWt009        128     138         numeric        "Replicate Weight #9" 
RepWt010        139     149         numeric        "Replicate Weight #10" 
RepWt011        150     160         numeric        "Replicate Weight #11" 
RepWt012        161     171         numeric        "Replicate Weight #12" 
RepWt013        172     182         numeric        "Replicate Weight #13" 
RepWt014        183     193         numeric        "Replicate Weight #14" 
RepWt015        194     204         numeric        "Replicate Weight #15" 
RepWt016        205     215         numeric        "Replicate Weight #16" 
RepWt017        216     226         numeric        "Replicate Weight #17" 
RepWt018        227     237         numeric        "Replicate Weight #18" 
RepWt019        238     248         numeric        "Replicate Weight #19" 
RepWt020        249     259         numeric        "Replicate Weight #20" 
RepWt021        260     270         numeric        "Replicate Weight #21" 
RepWt022        271     281         numeric        "Replicate Weight #22" 
RepWt023        282     292         numeric        "Replicate Weight #23" 
RepWt024        293     303         numeric        "Replicate Weight #24" 
RepWt025        304     314         numeric        "Replicate Weight #25" 
RepWt026        315     325         numeric        "Replicate Weight #26" 
RepWt027        326     336         numeric        "Replicate Weight #27" 
RepWt028        337     347         numeric        "Replicate Weight #28" 
RepWt029        348     358         numeric        "Replicate Weight #29" 
RepWt030        359     369         numeric        "Replicate Weight #30" 
RepWt031        370     380         numeric        "Replicate Weight #31" 
RepWt032        381     391         numeric        "Replicate Weight #32" 
RepWt033        392     402         numeric        "Replicate Weight #33" 
RepWt034        403     413         numeric        "Replicate Weight #34" 
RepWt035        414     424         numeric        "Replicate Weight #35" 
RepWt036        425     435         numeric        "Replicate Weight #36" 
RepWt037        436     446         numeric        "Replicate Weight #37" 
RepWt038        447     457         numeric        "Replicate Weight #38" 
RepWt039        458     468         numeric        "Replicate Weight #39" 
RepWt040        469     479         numeric        "Replicate Weight #40" 
RepWt041        480     490         numeric        "Replicate Weight #41" 
RepWt042        491     501         numeric        "Replicate Weight #42" 
RepWt043        502     512         numeric        "Replicate Weight #43" 
RepWt044        513     523         numeric        "Replicate Weight #44" 
RepWt045        524     534         numeric        "Replicate Weight #45" 
RepWt046        535     545         numeric        "Replicate Weight #46" 
RepWt047        546     556         numeric        "Replicate Weight #47" 
RepWt048        557     567         numeric        "Replicate Weight #48"' 



###############################################################################
# Location of CPS 1992 through 2019 replicate weights 92-93
###############################################################################

cps.replicate.data <- "./harmonzd.tus_cps.1992.through.2019.replicate.wgts.92_93.dat"


###############################################################################
# Create data dictionary
###############################################################################
tmp_file <- tempfile()
writeLines(data_diccionary, tmp_file)
data_diccionary_table <- read.table(tmp_file,sep="", col.names = c("variable", "initial_position","final_position", "type", "label"))

### Set varaible type numeric to "n" and characeter to "c"
levels(data_diccionary_table$type)<-c("c","n")
data_diccionary_tabletype <- as.character(data_diccionary_table$type)
### Create list for varaible name and type 
names(data_diccionary_tabletype) <-  data_diccionary_table$variable
data_diccionary_tabletype <- as.list(data_diccionary_tabletype)


###############################################################################
## Reading the CPS 1992 through 2019 replicate weights 92-93
##

harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta  <- as.data.frame(read_fwf(cps.replicate.data, 
 col_positions = fwf_positions( data_diccionary_table$initial_position, 
                 data_diccionary_table$final_position,
                  col_names= data_diccionary_table$variable),
                 col_types = data_diccionary_tabletype  )) 


###############################################################################
## Attaching labels
###############################################################################
for (i in 1:length(data_diccionary_table$variable))
{
  attr(harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta[,i],"label") <- data_diccionary_table$label[i]
}
dim(harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta)


###############################################################################
## Saving theCPS 1992 through 2019 replicate weights 92-93
###############################################################################

str(harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta, list.len=ncol(harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta))

saveRDS(harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta, file = "./harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta.RDS")


